package one.netspace.sdk;

public class NetspaceException extends RuntimeException {
    private final int statusCode;
    private final String errorCode;

    public NetspaceException(String message) {
        this(message, 0, "SDK_ERROR");
    }

    public NetspaceException(String message, int statusCode, String errorCode) {
        super(message);
        this.statusCode = statusCode;
        this.errorCode = errorCode;
    }

    public int getStatusCode() {
        return statusCode;
    }

    public String getErrorCode() {
        return errorCode;
    }
}
