import typescript from '@rollup/plugin-typescript';

export default [
  // UMD build (for browsers via script tag)
  {
    input: 'src/index.ts',
    output: {
      file: 'dist/netspace-sdk.js',
      format: 'umd',
      name: 'NetspaceSDK',
      exports: 'named',
    },
    plugins: [
      typescript({
        tsconfig: './tsconfig.json',
        declaration: true,
        declarationDir: './dist',
      }),
    ],
  },
  // ESM build (for modern bundlers)
  {
    input: 'src/index.ts',
    output: {
      file: 'dist/netspace-sdk.esm.js',
      format: 'esm',
    },
    plugins: [
      typescript({
        tsconfig: './tsconfig.json',
        declaration: false,
      }),
    ],
  },
];
