<?php

namespace Netspace;

class NetspaceException extends \Exception
{
    private int $statusCode;
    private string $errorCode;

    public function __construct(string $message, int $statusCode = 0, string $errorCode = 'SDK_ERROR')
    {
        parent::__construct($message);
        $this->statusCode = $statusCode;
        $this->errorCode = $errorCode;
    }

    public function getStatusCode(): int
    {
        return $this->statusCode;
    }

    public function getErrorCode(): string
    {
        return $this->errorCode;
    }
}
