class NetspaceException(Exception):
    """Exception raised for Netspace API errors."""

    def __init__(self, message: str, status_code: int = 0, error_code: str = 'SDK_ERROR'):
        super().__init__(message)
        self.message = message
        self.status_code = status_code
        self.error_code = error_code

    def __str__(self):
        return f"NetspaceException({self.error_code}): {self.message}"
